package gov.va.vinci.dart.biz;

import java.io.Serializable;

import javax.persistence.Column;
import javax.persistence.Embeddable;
import javax.persistence.EmbeddedId;
import javax.persistence.Entity;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;

@Entity
@Table(name="groupmailbox", schema="hib")
public class GroupMailbox implements Serializable {
	private static final long serialVersionUID = -3559408476971022247L;

	@EmbeddedId
	private GroupMailboxPK groupMailboxKey;

	
	@ManyToOne
	@JoinColumn(name="groupid", insertable=false, updatable=false)
	private Group group;

	@Column(name="notification", columnDefinition = "boolean", length = 1, insertable=false, updatable=false)
	private Boolean notification;
	
	@Column(name="email", length = 1, insertable=false, updatable=false)
	private String email;

	
	public Group getGroup() {
		return group;
	}

	public String getEmail() {
		return email;
	}

	public Boolean getNotification() {
		return notification;
	}
	
	
	@Embeddable
	private static class GroupMailboxPK implements Serializable {
		private static final long serialVersionUID = 6825006194818305691L;
		
		private int groupid;

		private String email;
		
		@Column(name="notification", columnDefinition = "BIT", length = 1)
		private boolean notification;

		
		public int getGroupid() {
			return groupid;
		}
		public void setGroupid(int groupid) {
			this.groupid = groupid;
		}

		public String getEmail() {
			return email;
		}
		public void setEmail(String email) {
			this.email = email;
		}

		public boolean isNotification() {
			return notification;
		}
		public void setNotification(boolean notification) {
			this.notification = notification;
		}
	}
	
}
